# Viewer Readme

This folder contains Java code samples showing how to use i-net Clear Reports viewer.

## CustomStatusBar.java

Shows how to remove the status bar from the viewer or to place your own status bar in its place.

[Click to open the sample file.](viewer/CustomStatusBar.java)

## ExportWithoutPreview.java

Shows how to create a viewer and export a report without having to preview it.

[Click to open the sample file.](viewer/ExportWithoutPreview.java)

## LoggingToFile.java

Shows how to change the logging from the default System.out console log to a file, or also how to disable logging completely.

[Click to open the sample file.](viewer/LoggingToFile.java)

## MultipleReportsView.java

Shows how i-net Clear Reports viewer can display more than one report at once in different "report views", which by default are shown in different tabs in the viewer.

[Click to open the sample file.](viewer/MultipleReportsView.java)

## PrintWithoutPreview.java

Shows how to print a report without having to preview it in the viewer first.

[Click to open the sample file.](viewer/PrintWithoutPreview.java)

## ProgressTracker.java

Shows how to stay informed about progress information, using a printing example to show how printing initialization, printing progress, and completion are all sent as events and can be handled by your own progress PropertyChangeListener.

[Click to open the sample file.](viewer/ProgressTracker.java)

## RemoveToolbarAction.java

Shows how simple it is to remove unwanted toolbar buttons from the viewer toolbar.

[Click to open the sample file.](viewer/RemoveToolbarAction.java)

## ReplaceInfoButton.java

Shows how quickly you can customize viewer behavior by providing your own ViewerContext object. This specific example replaces the info button action with a custom action.

[Click to open the sample file.](viewer/ReplaceInfoButton.java)

## ViewerInApplication.java

Shows how easy it is to integrate the i-net Clear Reports viewer in your own application.

[Click to open the sample file.](viewer/ViewerInApplication.java)

